/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)61	1.46.1.1  src/avs/fs/mmfs/ts/kernext/ibm-linux/cxiSharedSeg-plat.h, mmfs, avs_remp, rempt1d1 12/12/01 11:19:10 */
#ifndef _h_cxiSharedSeg_plat
#define _h_cxiSharedSeg_plat

#define SHARED_SEGMENT_BASE (UIntPtr(SharedSegmentBase))
EXTERN char* SharedSegmentBase;

#define SEGMENT_MAX_VMALLOC_PERCENT 50/100

/* ioctl ops */
enum kxOps
{
  RegisterMMFSDaemon                  = 1,
  WaitCondvar                         = 2,
  ThreadInitOrTerm                    = 3,
  SignalOrBroadcastCondvar            = 4,
  GetCondWaiters                      = 5,
  AllocEventWords                     = 6,
  InitKernelMailboxes                 = 7,
  EnableIO                            = 8,
  TerminateMailboxes                  = 9,
  StackAddrToThreadID                 = 10,
  kernelTrace                         = 11,
  GetDiskInfo                         = 12,
  RegisterMMFSSessionId               = 13,
  kernelRecLockReset                  = 14,
  SetCommState                        = 15,
  AcquireMutex                        = 16,
  ReleaseMutex                        = 17,
  RegisterNodeAddr                    = 18,
  InitializeRevokeTab                 = 19,
  RegisterObjType                     = 20,
  SetTraceLevel                       = 21,
  kxtraceit                           = 22,
  kPoll                               = 23,
  GetLocalSGIdCounter                 = 24,
  QueueCompletedIO                    = 25,
  AwaitIOCompletion                   = 26,
  StartIO                             = 27,
  GetSimpleLock                       = 28,
  MapPrivate                          = 29,
  SetMountInfoByID                    = 30,
  FreeMailboxStorage                  = 31,
  RegisterMMFSSeg                     = 32,
#ifdef SMB_LOCKS
  BreakOplock                         = 33,
#endif
  GetStructSize                       = 34,
  GetMapCount                         = 35,
  DefineShSeg                         = 36,
  SetPrivLevel                        = 37,
  kernelSendFlock                     = 38,
  kernelWaitForFlock                  = 39,
  kernelCommonReclock                 = 40,
  kernelDoTraceDump                   = 41,
#ifdef SIMPLE_PAGEDECL
  SetNPagesAvailable                  = 42,
  // unused                           = 43,
#else
  UndeclarePages                      = 42,
  DeclarePages                        = 43,
#endif
  PinKernelIOBuffer                   = 44,
  UnpinKernelIOBuffer                 = 45,
  SplitKernelIOBuffer                 = 46,
  MergeKernelIOBuffers                = 47,
  UnpinAllKernelIOBuffers             = 48,
  kernelRLRevokeLock                  = 49,
  kernelRLRevokeUnLock                = 50,
  setPrivilegeLevel                   = 51,
  getPrivilegeLevel                   = 52,
  Fattr                               = 53,
  Attr                                = 54,
  GetACL                              = 55,
  PutACL                              = 56,
  Fstat                               = 57,
  Stat                                = 58,
  AtomvarInit                         = 59,
  VFSStatCtl                          = 60,
  // unused                           = 61,
  kernelMmapControl                   = 62,
  kernelMmapInfo                      = 63,
  CatalogGetMounts                    = 64,
  GetMountInfoByID                    = 65,
  uvmount                             = 66,
  saveThreadInfo                      = 67,
  kernelMmapFlush                     = 68,
  InvalidateOSNode                    = 69,
  InitKernelBufferManager             = 70,
  AbortPageWaiters                    = 71,
  AllocVinfo                          = 72,
  CleanupVinfo                        = 73,
  kernelMadvise                       = 74,
  updateOSNode                        = 75,
  GetPAG                              = 76,
  SetPAG                              = 77,
  GetUserMap                          = 78,
  SetUserMap                          = 79,
  GetDosAttr                          = 80,
  SetDosAttr                          = 81,
  CalcMaxSharedKernelMemory           = 82,
  AllocSharedKernelMemory             = 83,
  MapAllSharedKernelMemory            = 84,
  DeallocAllSharedKernelMemory        = 85,
  SetTakeOwnership                    = 86,
  InitializeNodeHashTab               = 87,
  ClampLocks                          = 88,
  UnClampLocks                        = 89,
  CheckNTAccess                       = 90,
  noOp                                = 91,
  InvalidateSnapshot                  = 92,
  CleanupStaleNFS                     = 93,
  GetKernelBoundary                   = 94,
  SetMultiNode                        = 95,
  BlockingMutexStatsCtl               = 96,
  FindCloseNFS                        = 97,
  SetMachineSID                       = 98,
  GetPrivLevel                        = 99,
  InvalidateVolatileOSNodes           = 100,
  ThreadPtrToThreadID                 = 101
};

#define kxOp_tostring(ent) \
  (((ent) == 0)? "UNUSED 0"                           : \
   ((ent) == 1)? "RegisterMMFSDaemon"                 : \
   ((ent) == 2)? "WaitCondvar"                        : \
   ((ent) == 3)? "ThreadInitOrTerm"                   : \
   ((ent) == 4)? "SignalOrBroadcastCondvar"           : \
   ((ent) == 5)? "GetCondWaiters"                     : \
   ((ent) == 6)? "AllocEventWords"                    : \
   ((ent) == 7)? "InitKernelMailboxes"                : \
   ((ent) == 8)? "EnableIO"                           : \
   ((ent) == 9)? "TerminateMailboxes"                 : \
   ((ent) == 10)? "StackAddrToThreadID"               : \
   ((ent) == 11)? "kernelTrace"                       : \
  ((ent) == 12)? "GetDiskInfo"                        : \
  ((ent) == 13)? "RegisterMMFSSessionId "             : \
  ((ent) == 14)? "kernelRecLockReset"                 : \
  ((ent) == 15)? "SetCommState"                       : \
  ((ent) == 16)? "AcquireMutex"                       : \
  ((ent) == 17)? "ReleaseMutex"                       : \
  ((ent) == 18)? "RegisterNodeAddr"                   : \
  ((ent) == 19)? "InitializeRevokeTab"                : \
  ((ent) == 20)? "RegisterObjType"                    : \
  ((ent) == 21)? "SetTraceLevel"                      : \
  ((ent) == 22)? "kxtraceit"                          : \
  ((ent) == 23)? "kPoll"                              : \
  ((ent) == 24)? "GetLocalSGIdCounter"                : \
  ((ent) == 25)? "QueueCompletedIO"                   : \
  ((ent) == 26)? "AwaitIOCompletion"                  : \
  ((ent) == 27)? "StartIO"                            : \
  ((ent) == 28)? "GetSimpleLock"                      : \
  ((ent) == 29)? "MapPrivate"                         : \
  ((ent) == 30)? "SetMountInfoByID"                   : \
  ((ent) == 31)? "FreeMailboxStorage"                 : \
  ((ent) == 32)? "RegisterMMFSSeg"                    : \
  ((ent) == 33)? "BreakOplock"                        : \
  ((ent) == 34)? "GetStructSize"                      : \
  ((ent) == 35)? "GetMapCount"                        : \
  ((ent) == 36)? "DefineShSeg"                        : \
  ((ent) == 37)? "SetPrivLevel"                       : \
  ((ent) == 38)? "kernelSendFlock"                    : \
  ((ent) == 39)? "kernelWaitForFlock"                 : \
  ((ent) == 40)? "kernelCommonReclock"                : \
  ((ent) == 41)? "kernelDoTraceDump"                  : \
  ((ent) == 42)? "UndeclarePages"                     : \
  ((ent) == 43)? "DeclarePages"                       : \
  ((ent) == 44)? "PinKernelIOBuffer"                  : \
  ((ent) == 45)? "UnpinKernelIOBuffer"                : \
  ((ent) == 46)? "SplitKernelIOBuffer"                : \
  ((ent) == 47)? "MergeKernelIOBuffers"               : \
  ((ent) == 48)? "UnpinAllKernelIOBuffers"            : \
  ((ent) == 49)? "kernelRLRevokeLock"                 : \
  ((ent) == 50)? "kernelRLRevokeUnLock"               : \
  ((ent) == 51)? "setPrivilegeLevel"                  : \
  ((ent) == 52)? "getPrivilegeLevel"                  : \
  ((ent) == 53)? "Fattr"                              : \
  ((ent) == 54)? "Attr"                               : \
  ((ent) == 55)? "GetACL"                             : \
  ((ent) == 56)? "PutACL"                             : \
  ((ent) == 57)? "Fstat"                              : \
  ((ent) == 58)? "Stat"                               : \
  ((ent) == 59)? "AtomvarInit"                        : \
  ((ent) == 60)? "VFSStatCtl"                         : \
  ((ent) == 61)? "UNUSED 61"                          : \
  ((ent) == 62)? "kernelMmapControl"                  : \
  ((ent) == 63)? "kernelMmapInfo"                     : \
  ((ent) == 64)? "CatalogGetMounts"                   : \
  ((ent) == 65)? "GetMountInfoByID"                   : \
  ((ent) == 66)? "uvmount"                            : \
  ((ent) == 67)? "saveThreadInfo"                     : \
  ((ent) == 68)? "kernelMmapFlush"                    : \
  ((ent) == 69)? "InvalidateOSNode"                   : \
  ((ent) == 70)? "InitKernelBufferManager"            : \
  ((ent) == 71)? "AbortPageWaiters"                   : \
  ((ent) == 72)? "AllocVinfo"                         : \
  ((ent) == 73)? "CleanupVinfo"                       : \
  ((ent) == 74)? "kernelMadvise"                      : \
  ((ent) == 75)? "updateOSNode"                       : \
  ((ent) == 76)? "GetPAG"                             : \
  ((ent) == 77)? "SetPAG"                             : \
  ((ent) == 78)? "GetUserMap"                         : \
  ((ent) == 79)? "SetUserMap"                         : \
  ((ent) == 80)? "GetDosAttr"                         : \
  ((ent) == 81)? "SetDosAttr"                         : \
  ((ent) == 82)? "CalcMaxSharedKernelMemory"          : \
  ((ent) == 83)? "AllocSharedKernelMemory"            : \
  ((ent) == 84)? "MapAllSharedKernelMemory"           : \
  ((ent) == 85)? "DeallocAllSharedKernelMemory"       : \
  ((ent) == 86)? "SetTakeOwnership"                   : \
  ((ent) == 87)? "InitializeNodeHashTab"              : \
  ((ent) == 88)? "ClampLocks"                         : \
  ((ent) == 89)? "UnClampLocks"                       : \
  ((ent) == 90)? "CheckNTAccess"                      : \
  ((ent) == 91)? "noOp"                               : \
  ((ent) == 92)? "InvalidateSnapshot"                 : \
  ((ent) == 93)? "CleanupStaleNFS"                    : \
  ((ent) == 94)? "GetKernelBoundary"                  : \
  ((ent) == 95)? "SetMultiNode"                       : \
  ((ent) == 96)? "BlockingMutexStatsCtl"              : \
  ((ent) == 97)? "FindCloseNFS"                       : \
  ((ent) == 98)? "SetMachineSID"                      : \
  ((ent) == 99)? "GetPrivLevel"                       : \
  ((ent) == 100)? "InvalidateVolatileOSNodes"         : \
  ((ent) == 101)? "ThreadPtrToThreadID"               : \
   "??")

#define MAX_SS_IOCTL_OPS 102

struct kxArgs
{
  long arg1;
  long arg2;
  long arg3;
  long arg4;
  long arg5;
};

#define GPFS_SUPER_MAGIC     0xBEEF

#ifdef __cplusplus
extern "C"
{
#endif
  int setss();
  int ss_init();
  void gpfs_proc_export_init(void);
  void gpfs_proc_export_term(void);
#ifdef CONFIG_NSS
  void cred_init();
  void cred_cleanup();
#endif
#ifdef SMB_LOCKS
  void oplock_init();
  void oplock_cleanup();
#endif
  void InitSharedKernelMemory();
  void TermSharedKernelMemory();
#ifdef __cplusplus
}
#endif

#define ASSERTBASESEG(ADDR, REA, TAG)

#ifdef GPFS_ARCH_IA64
#define SET_PRIVILEGE_LEVEL()                \
  int fd_x;                                  \
  fd_x = open(GPFS_DEVNAME, O_RDWR);         \
  if (fd_x > 0)                              \
  {                                          \
    ioctl(fd_x, SetPrivLevel, 1);            \
    close(fd_x);                             \
  }
#else
#define SET_PRIVILEGE_LEVEL() (NOOP)
#endif

#ifdef __cplusplus
EXTERNC int (*ss_ioctl_op[MAX_SS_IOCTL_OPS+1])(...);
#else
EXTERNC int (*ss_ioctl_op[MAX_SS_IOCTL_OPS+1])();
#endif /* __cplusplus */

/* Compute how large the total size of all shared kernel memory regions
   is allowed to grow, based on a desired size.  A value of 0 for
   desiredBytes means to compute the default maximum size. */
EXTERNC int cxiCalcMaxSharedKernelMemory(int desiredBytes, int* actualBytesP);

/* Acquire additional memory that is accessible using the same address from
   both kernel code and the GPFS daemon.  Will get at least minBytes.
   Returns the starting virtual address of the area and its actual length. */
EXTERNC int cxiAllocSharedKernelMemory(int minBytes, char** vaddrPP,
                                       int* actualBytesP);

/* Map all of the memory allocated by kxAllocSharedKernelMemory into the
   address space of the calling process */
EXTERNC int cxiMapAllSharedKernelMemory(char** basePP);

/* Unmap and deallocate all memory allocated by kxAllocSharedKernelMemory */
EXTERNC int cxiDeallocAllSharedKernelMemory();

/* Map a section of memory MAP_PRIVATE */
EXTERNC int kxMapPrivate(char *inAddr, unsigned long len, unsigned long prot,
                         char **outAddr);

#endif /* _h_cxiSharedSeg_plat */
